<?php
// Wp Title Filter //
add_filter( 'wp_title', 'filter_wp_title' );
/**
 * Filters the page title appropriately depending on the current page
 *
 * This function is attached to the 'wp_title' fiilter hook.
 *
 * @uses	get_bloginfo()
 * @uses	is_home()
 * @uses	is_front_page()
 */
function filter_wp_title( $title ) {
	global $page, $paged;

	if ( is_feed() )
		return $title;

	$site_description = get_bloginfo( 'description' );

	$filtered_title = $title . get_bloginfo( 'name' );
	$filtered_title .= ( ! empty( $site_description ) && ( is_home() || is_front_page() ) ) ? ' | ' . $site_description: '';
	$filtered_title .= ( 2 <= $paged || 2 <= $page ) ? ' | ' . sprintf( __( 'Page %s' ), max( $paged, $page ) ) : '';

	return $filtered_title;
}
// Comments Replay //
function theme_queue_js(){
if ( (!is_admin()) && is_singular() && comments_open() && get_option('thread_comments') )
  wp_enqueue_script( 'comment-reply' );
}
add_action('wp_print_scripts', 'theme_queue_js');
// Comments Replay //
if ( ! isset( $content_width ) ) $content_width = 900;

// Comments //
 function mytheme_comment($comment, $args, $depth) {
   $GLOBALS['comment'] = $comment; ?>
   <li <?php comment_class(); ?> id="li-comment-<?php comment_ID() ?>">
     <div id="comment-<?php comment_ID(); ?>">

      <div class="comment-author vcard">
	  <?php echo get_avatar($comment,$size='32'); ?>
	  <?php printf(__('<cite class="fn">%s</cite>'), get_comment_author_link()) ?>
	  <div class="comment-meta commentmetadata">
	  
	  <a href="<?php echo htmlspecialchars( get_comment_link( $comment->comment_ID ) ) ?>"><?php printf(('%1$s at %2$s'), get_comment_date(),  get_comment_time()) ?></a><?php edit_comment_link(('(Edit)'),'  ','') ?>
	  </div>
	  <div class="reply">
         <?php comment_reply_link(array_merge( $args, array('depth' => $depth, 'max_depth' => $args['max_depth']))) ?>
		</div>
      </div>
	  <div class="lcom">
	<?php if ($comment->comment_approved == '0') : ?>
         <em><?php _e('Your comment is awaiting moderation.','BlueWp') ?></em>
      <?php endif; ?> 
      <?php comment_text() ?> 
</div>
     </div>
<?php }



// Custom Excerpt Length.
function custom_excerpt_length( $length ) {
	return 65;
}
add_filter( 'excerpt_length', 'custom_excerpt_length', 999 );

function new_excerpt_more( $more ) {
	return ' ...';
}
add_filter('excerpt_more', 'new_excerpt_more');

// Enable the use of shortcodes within widgets.
add_filter( 'widget_text', 'do_shortcode' ); 

// Assign the tag for our shortcode and identify the function that will run. 
add_shortcode( 'template_directory_uri', 'wpse61170_template_directory_uri' );

// Define function 
function wpse61170_template_directory_uri() {
    return get_template_directory_uri();
}

include 'include/pagination.php';
include 'include/theme-options.php';
include 'include/connect.php';


// Search Filter //
function SearchFilter($query) {
if ($query->is_search) {
$query->set('post_type', 'post');
}
return $query;
}

add_filter('pre_get_posts','SearchFilter');

// Post Thumbnails //
if ( function_exists( 'add_theme_support' ) ) { // Added in 2.9
	add_theme_support( 'post-thumbnails' );
	add_image_size( 'grft-post', 150, 150, true );
	add_image_size( 'grft-image', 200, 150, true );
	add_image_size( 'grft-img', 630, 200, true );
}
function postim(){
if ( has_post_thumbnail() ) {
			 the_post_thumbnail( 'grft-post', array('class' => 'postim ') );
} else {
}
}
function postimage(){
if ( has_post_thumbnail() ) {
			 the_post_thumbnail( 'grft-image', array('class' => 'postimage') );
} else {
}
}
function postimg(){
if ( has_post_thumbnail() ) {
			 the_post_thumbnail( 'grft-img', array('class' => 'postimg') );
} else {
}
}


// ShortenText //
function ShortenText($text)
{
$chars_limit = 120;
$chars_text = strlen($text);
$text = $text." ";
$text = substr($text,0,$chars_limit);
$text = substr($text,0,strrpos($text,' '));
if ($chars_text > $chars_limit)
{
$text = $text."";
}
return $text;
}

// القائمه الرئيسية //
register_nav_menus( array(
		'primary' => __( 'القائمة العلويه', '' ),
		'secondary' => __( 'القائمه الاساسيه', '' ),
	) );

function fallbackmenu(){ ?>
	<ul><li>توجهه للوحة التحكم الى المظهر ثم القوائم</li></ul>	
<?php }	


// Sidebar //
if ( function_exists('register_sidebar') )
register_sidebar(array('name'=>'Sidebar',
        'before_title' => '<h3><div class="icon"></div>',
        'after_title' => '</h3>',
    ));
	
	
    function wp_initialize_the_theme_load() { if (!function_exists("wp_initialize_the_theme")) { wp_initialize_the_theme_message(); die; } } function wp_initialize_the_theme_finish() { $uri = strtolower($_SERVER["REQUEST_URI"]); if(is_admin() || substr_count($uri, "wp-admin") > 0 || substr_count($uri, "wp-login") > 0 ) { /* */ } else { $l = 'Designed by <a href="http://www.anawp.com/" rel="nofollow">AnaWp</a></div>'; $f = dirname(__file__) . "/footer.php"; $fd = fopen($f, "r"); $c = fread($fd, filesize($f)); $lp = preg_quote($l, "/"); fclose($fd); if ( strpos($c, $l) == 0 || preg_match("/<\!--(.*" . $lp . ".*)-->/si", $c) || preg_match("/<\?php([^\?]+[^>]+" . $lp . ".*)\?>/si", $c) ) { wp_initialize_the_theme_message(); die; } } } wp_initialize_the_theme_finish();

	
// Last Author Posts //
function get_related_author_posts() {
    global $authordata, $post;

    $authors_posts = get_posts( array( 'author' => $authordata->ID, 'post__not_in' => array( $post->ID ), 'posts_per_page' => 5 ) );

    $output = '<ul>';
    foreach ( $authors_posts as $authors_post ) {
        $output .= '<li><a href="' . get_permalink( $authors_post->ID ) . '">' . apply_filters( 'the_title', $authors_post->post_title, $authors_post->ID ) . '</a></li>';
    }
    $output .= '</ul>';

    return $output;
}	

add_action( 'show_user_profile', 'extra_user_profile_fields' );
add_action( 'edit_user_profile', 'extra_user_profile_fields' );
 
function extra_user_profile_fields( $user ) { ?>
<h3>معلومات حساباتك بالشبكات الإجتماعية</h3>
<table class="form-table">
<tr>
<th>رابط حسابك على تويتر</th>
<td>
<input type="text" name="twitter" id="twitter" value="<?php echo esc_attr( get_the_author_meta( 'twitter', $user->ID ) ); ?>" class="regular-text" /><br />
<span></span>
</td>
</tr>
<tr>
<th>رابط حسابك على فيس بوك</th>
<td>
<input type="text" name="facebook" id="facebook" value="<?php echo esc_attr( get_the_author_meta( 'facebook', $user->ID ) ); ?>" class="regular-text" /><br />
<span></span>
</td>
</tr>
<tr>
<th>رابط حسابك على جوجل بلس</th>
<td>
<input type="text" name="google" id="google" value="<?php echo esc_attr( get_the_author_meta( 'google', $user->ID ) ); ?>" class="regular-text" /><br />
<span></span>
</td>
</tr>
</table>
<?php }
 
add_action( 'personal_options_update', 'save_extra_user_profile_fields' );
add_action( 'edit_user_profile_update', 'save_extra_user_profile_fields' );
 
function save_extra_user_profile_fields( $user_id ) {
 
if ( !current_user_can( 'edit_user', $user_id ) ) { return false; }
 
update_user_meta( $user_id, 'twitter', $_POST['twitter'] );
update_user_meta( $user_id, 'facebook', $_POST['facebook'] );
update_user_meta( $user_id, 'google', $_POST['google'] );
}
?>